package complex_operations;

import db_context.DbContext;
import row_data_gateway.SegmentFinder;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Statistics {

    private static final Statistics INSTANCE = new Statistics();
    public static Statistics getInstance() {
        return INSTANCE;
    }

    private Statistics() {
    }

    //Stats - successfully delivered packages to damaged ratio
    public void PackageStats() throws SQLException {
        System.out.println("...year...|.month.|...delivered...|...damaged...|...del change...|...dam change...");
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(getStats1_statement)){
            try(ResultSet r = s.executeQuery()){
                while (r.next()){
                    System.out.print("   ");
                    System.out.print(r.getInt(1) + "       ");
                    System.out.print(r.getInt(2) + "        ");
                    System.out.print(r.getBigDecimal(3).setScale(3, BigDecimal.ROUND_DOWN) + "%         ");
                    System.out.print(r.getBigDecimal(4).setScale(3, BigDecimal.ROUND_DOWN) + "%         ");
                    System.out.print(r.getBigDecimal(6).setScale(3, BigDecimal.ROUND_DOWN) + "%          ");
                    System.out.println(r.getBigDecimal(7).setScale(3, BigDecimal.ROUND_DOWN) + "%      ");
                }
            }
        }
    }

    //Stats - locations with most transitions without accident
    public void LocationsStats() throws SQLException{
        System.out.println("...year...|..quarter..|.....location.....|..transits..");
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(getStats2_statement)){
            try(ResultSet r = s.executeQuery()){
                while (r.next()){
                    System.out.print(OtherOperations.getInstance().Adjust(r.getInt(1)+"", 10));
                    if(r.getInt(2) == -1) System.out.print(OtherOperations.getInstance().Adjust("-",11));
                    else System.out.print(OtherOperations.getInstance().Adjust(r.getInt(2) + "", 11));
                    System.out.print(OtherOperations.getInstance().Adjust(r.getString(3), 19));
                    System.out.println(OtherOperations.getInstance().Adjust(r.getInt(4)+"", 13));
                }
            }
        }
    }

    String getStats1_statement = "" +
            "select tab1.*, tab1.actual1 - tab2.prev1, tab1.actual2 - tab2.prev2 from\n" +
            "(select\n" +
            "    date_part('year', t.departure_time) as year,\n" +
            "    date_part('month', t.departure_time) as month,\n" +
            "    count(case p.status = 'delivered' when true then 1 end)/(count(*)* 0.01) as actual1,\n" +
            "    count(case p.status = 'refunded' when true then 1 end)/(count(*) * 0.01) as actual2,\n" +
            "    row_number() over () as rank\n" +
            "from packages p join transports t on p.id = t.package_id\n" +
            "group by year, month) as tab1\n" +
            "\n" +
            "join\n" +
            "\n" +
            "(select\n" +
            "     date_part('year', t.departure_time) as year,\n" +
            "     date_part('month', t.departure_time) as month,\n" +
            "     count(case p.status = 'delivered' when true then 1 end)/(count(*) * 0.01) as prev1,\n" +
            "     count(case p.status = 'refunded' when true then 1 end)/(count(*) * 0.01) as prev2,\n" +
            "     row_number() over () as rank\n" +
            " from packages p join transports t on p.id = t.package_id\n" +
            " group by year, month) as tab2\n" +
            "\n" +
            "on tab1.rank = tab2.rank + 1";

    String getStats2_statement = "" +
            "select * from\n" +
            "    (select date_part('year', s.time) as year,\n" +
            "        date_part('quarter', s.time) as month,\n" +
            "        location_name(c.loca_id),\n" +
            "        count(*) as co,\n" +
            "        row_number() over (partition by date_part('year', s.time), date_part('quarter', s.time) order by count(*) desc) as rank\n" +
            "    from  segments s join connections c on s.connection_id = c.id\n" +
            "    where s.accident = false\n" +
            "    group by year, month, c.loca_id\n" +
            "    order by year, month, co asc ) as subquery\n" +
            "where rank < 4\n" +
            "\n" +
            "union\n" +
            "\n" +
            "select subquery.year, -1, subquery.location_name, subquery.count,subquery.rank from\n" +
            "    (select date_part('year', s.time) as year,\n" +
            "            location_name(c.loca_id) as location_name,\n" +
            "            count(*) as count,\n" +
            "            row_number() over (partition by date_part('year', s.time) order by count(*) desc) as rank\n" +
            "    from  segments s join connections c on s.connection_id = c.id\n" +
            "    where s.accident = false\n" +
            "    group by year, c.loca_id\n" +
            "    order by year, count asc) as subquery\n" +
            "where rank < 4;";
}
